#---------------------------------------------------------------------------
# Copyright 2012 The Open Source Electronic Health Record Agent
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#---------------------------------------------------------------------------

from AddOneClinic import AddOneClinic

def AddClinics(VistA,state):
  if state=='ALABAMA':
    primary = ['SMITH,JAMES','JOHNSON,MICHAEL','WILLIAMS,TIMOTHY','ALEXANDER,ROBERT']
  elif state == 'GEORGIA':
    primary = ['SMITH,JANE','JOHNSON,MICHAEL','CLARK,GEORGE','KIRK,JOSEPH']
  AddOneClinic(VistA,'Mental Health'                 ,'ALMH  ','555-555-1414',primary[2],'301','301','M','N',state + ' VA MEDICAL CENTER' ,state + ' VA MEDICAL CENTER','30')
  AddOneClinic(VistA,'Medical Center Primary Care'    ,'ALPC1 ','555-555-2525',primary[0],'301','301','M','N',state + ' VA MEDICAL CENTER' ,state + ' VA MEDICAL CENTER','30')
  AddOneClinic(VistA,'Orthopedics'                   ,'ALORTH','555-555-3636',primary[1],'301','301','M','N',state + ' VA MEDICAL CENTER' ,state + ' VA MEDICAL CENTER','30')
  AddOneClinic(VistA,'OutPatient Primary Care'       ,'ALPC2 ','555-555-4747',primary[0],'301','301','M','N',state + ' VA OUTPATIENT CLINC',state + ' VA MEDICAL CENTER','30')
  AddOneClinic(VistA,'Audiology'                     ,'ALAUD ','555-555-5858',primary[3],'301','301','M','N',state + ' VA OUTPATIENT CLINC',state + ' VA MEDICAL CENTER','30')

def AddClinicsByConfig(VistA, clinicsJson):
  for clinic in clinicsJson:
    print clinic
    AddOneClinic(VistA, clinic['Name'], clinic['Abbreviation'],
                 clinic['Phone Number'], clinic['Provider'],
                 clinic['Stop Code'], clinic['Credit Stop Code'],
                 clinic['Service Type'], clinic['Non-Count'],
                 clinic['Parent Division'], clinic['Parent Institution'],
                 clinic['Appointment Length'])
